/*
 * @(#)SimulationEvent.java  1.0  2. Dezember 2003
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.simulation;

import java.util.*;
/**
 * An event which indicates a change in an element of the Simulation.
 *
 * @author  Werner Randelshofer
 * @version 1.0 2. Dezember 2003  Created.
 */
public class SimulationEvent extends java.util.EventObject {
    private SimulatedObject object;
    
    /** Creates a new instance. */
    public SimulationEvent(Simulation source, SimulatedObject object) {
        super(source);
        this.object = object;
    }
    
    public Simulation getSimulation() {
        return (Simulation) getSource();
    }
    public SimulatedObject getObject() {
        return object;
    }
    public SimulatedElement getElement() {
        return (SimulatedElement) object;
    }
}
